/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件为 webUI 大屏显示
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_table */
/* exported mc_get_id */
/* exported mc_table_js_fun */
/* exported mc_table_fast_connections_0 */
/* exported mc_table_fast_connections_1 */
/* exported mc_table_fast_connections_2 */
/* exported mc_table_fast_connections_3 */
/* exported mc_table_fast_connections_4 */
/* exported mc_table_fast_connections_5 */
/* exported mc_table_fast_connections_6 */
/* exported mc_table_fast_connections_7 */
/* exported mc_table_content_updata */
/* exported mc_table_content_updata_network */
/* exported mc_table_retracement_network */
/* exported mc_table_find_elem_idx */
/* exported mc_table_set_data */
/* exported mc_table_get_data */
/* exported mc_tabel_reset_network */
/* exported mc_table_get_data_all */
/* global $ */
/* global mc_content_click */
/* global screen_network_num */
/* global mc_lang_update_page */
/* global obj_lang_screen */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取动态ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> } 动态ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_id() {
    return new Date().getTime() + (Math.random() * 1000).toFixed(0);
}

// 定义传递函数
var g_str_attr_lab_val_chg = "on_val_chg";
var g_obj_func_name_map = {};

//总数据数组
var ary_table_current_data_all = [];
//当前数据数组
var ary_table_current_data = [];

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    通过网口获取总数据下标
 * 参数:
 *    @param {string} networlk 网口
 * 返回：
 *    @return { Promise<string> } 当前网口在总数据中的下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_table_circulation_ary_get_idx(networlk) {
    if (0 >= ary_table_current_data_all.length) {
        return false;
    }
    networlk = Number(networlk);
    if (0 > networlk || 16 < networlk) {
        return false;
    }
    for (var idx = 0; idx < ary_table_current_data_all.length; idx++) {
        var ui_network = ary_table_current_data_all[idx].network;

        ui_network = Number(ui_network);
        if (networlk === ui_network) {
            return idx.toString();
        }
    }
    return false;
}

function mc_table() {
    var str_table_id = "";
    // 表格样式
    var arr_style = [];
    //行数
    var table_line = 1;
    //列数
    var table_column = 1;

    this.on_val_chg = function () {};

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    修改表格内容
     * 参数:
     *    @param {object} obj_data_all 表格数据
     * 返回：
     *    @return { Promise<boolean> } 修改结果
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/

    this.get_new_table = function (obj_data_all) {
        if (!$.isPlainObject(obj_data_all)) {
            return false;
        }
        ary_table_current_data_all = [];
        table_line = obj_data_all.table_column;
        table_line = Number(table_line);
        table_column = obj_data_all.table_line;
        table_column = Number(table_column);
        $(".mc_table").parent().empty().append(this.get_html_txt());
        var ary_data_all = obj_data_all.data;

        for (var idx_all = 0; idx_all < ary_data_all.length; idx_all++) {
            var obj_network_data = ary_data_all[idx_all];
            var network = obj_network_data.network;
            var ary_data_network = obj_network_data.network_data;
            var obj_data = {
                network: network,
                data: [],
                null_data: []
            };
            var ui_receiver_old = 0;

            for (var idx_network = 0; idx_network < ary_data_network.length; idx_network++) {
                var str_content = ary_data_network[idx_network];
                var ary_content = str_content.split(",");
                var obj_this = {
                    network: network,
                    content_x: ary_content[0],
                    content_y: ary_content[1],
                    content_receiver: ary_content[2],
                    content_width: ary_content[3],
                    content_height: ary_content[4]
                };
                var ui_receiver = Number(ary_content[2]);

                if ((ui_receiver_old + 1) !== ui_receiver) {
                    var ui_cnt = ui_receiver - (ui_receiver_old + 1);

                    ui_cnt--;
                    for (var idx_null = 0; idx_null < ui_cnt.length; idx_null++) {
                        obj_data.null_data.push((ui_receiver_old + 1 + idx_null));
                    }
                }
                ui_receiver = ary_content[2];
                ui_receiver = Number(ui_receiver);
                obj_data.data.push(mc_table_construction_jq_obj(obj_this));
            }
            ary_table_current_data_all.push(obj_data);
        }
        // $("#mc_table_content").niceScroll({
        //     zindex: 999
        //     // overflowx: true
        // });
        mc_table_js_fun();
        mc_table_content_se();
        mc_table_ligature();
        return true;
    };

    function mc_table_construction_jq_obj(obj_content) {
        if (!$.isPlainObject(obj_content)) {
            return false;
        }
        var network = obj_content.network;
        var content_x = obj_content.content_x;
        var content_y = obj_content.content_y;
        var content_receiver = obj_content.content_receiver;
        var content_width = obj_content.content_width;
        var content_height = obj_content.content_height;

        network = Number(network);
        content_x = Number(content_x);
        content_x--;
        content_y = Number(content_y);
        content_y--;
        content_receiver = Number(content_receiver);
        content_width = Number(content_width);
        content_height = Number(content_height);
        //当前需要操作的jq对象
        var $this = $("#mc_table_content_body").children(".mc_table_y").eq(content_y).children(".mc_table_content").eq(content_x);

        $this.children("#mc_table_network").children("#network_num").text(network);
        $this.children("#mc_table_receiving_card").children("#receiver_num").text(content_receiver);
        if (0 === network) {
            $this.children("#mc_table_network").css("opacity", "0");
            $this.children("#mc_table_receiving_card").children("#receiver_num").text(obj_lang_screen.MC_LANG_BTN_SCREEN_SET_NULL);
        }
        $this.children("#mc_table_width").children("#width_num").text(content_width);
        $this.children("#mc_table_height").children("#height_num").text(content_height);
        $this.addClass("mc_table_internet_access_" + network).children().css("display", "block");
        return $this;
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    取得表格的ID
     *
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     表格的ID
     *     null 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_table_id.length) {
            return null;
        }
        return str_table_id;
    };
    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    取得表格的ID 操作dom
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     表格的ID
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_table_id).attr("id");
    };
    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    操作dom表格行数
     * 参数:
     *    @param {string} str_line 表格行数
     * 返回：
     *    @return { Promise<boolean> }
     *     成功与否布尔值
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/
    this.table_operation_line = function (str_line) {
        if ("string" !== typeof str_line || 0 >= str_line.length) {
            return false;
        }
        var ui_line = Number(str_line);

        if (0 > ui_line || ui_line === table_line) {
            return false;
        }
        table_line = ui_line;
        var table_tr = $(".mc_table_y");
        var table_td = [];
        var idx_y = 0;
        var idx_x = 0;

        if (ui_line < table_tr.length) {
            for (idx_y = 0; idx_y < (table_tr.length - ui_line); idx_y++) {
                table_td = $(".mc_table_y").eq(-1).children();

                for (idx_x = 0; idx_x < table_td.length; idx_x++) {
                    mc_table_remove_child(table_td.eq(idx_x));
                    table_td.eq(idx_x).remove();
                }
                $(".mc_table_y").eq(-1).remove();
                $("#mc_table_first_column").children().eq(-1).remove();
            }
            mc_table_content_se();
            mc_table_ligature();
            // $("#mc_table_content").getNiceScroll().resize();
            return true;
        }
        var str_add_html = "";
        var str_add_html_line = "";
        var content_add_p = mc_table_get_p_text();

        for (idx_y = 0; idx_y < (ui_line - table_tr.length); idx_y++) {
            str_add_html_line += "<div class='mc_table_first_column'>" + ($(".mc_table_first_column").length + 1 + idx_y) + "</div>";
            str_add_html += "<div class='mc_table_y'>";
            for (idx_x = 0; idx_x < table_column; idx_x++) {
                str_add_html += "<div class='mc_table_content' id='mc_table_content_" + (idx_x + 1) + "_" + ($(".mc_table_first_column").length + 1 + idx_y) + "' onclick=' mc_table_content_click(this);'>" + content_add_p + "</div>";
            }
            str_add_html += "</div>";
        }
        $("#mc_table_first_column").append(str_add_html_line);
        $("#mc_table_content_body").append(str_add_html);
        // $("#mc_table_content").getNiceScroll().resize();

        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    操作dom表格列数
     * 参数:
     *    @param {string} str_column 表格列数
     * 返回：
     *    @return { Promise<boolean> }
     *     成功与否布尔值
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/
    this.table_operation_column = function (str_column) {
        if ("string" !== typeof str_column || 0 >= str_column.length) {
            return false;
        }
        var ui_column = Number(str_column);

        if (0 > ui_column || ui_column === table_column) {
            return false;
        }
        table_column = ui_column;
        var table_tr = $(".mc_table_y");
        var ui_td_cnt = $("#mc_table_first_line").children().length;
        var idx_num = 0;
        var idx_dom = 0;

        if (ui_column < ui_td_cnt) {
            for (idx_num = 0; idx_num < ui_td_cnt - ui_column; idx_num++) {
                $("#mc_table_first_line").children().eq(-1).remove();
                for (idx_dom = 0; idx_dom < table_tr.length; idx_dom++) {
                    var table_td = table_tr.eq(idx_dom).children();

                    mc_table_remove_child(table_td.eq(-1));
                    table_td.eq(-1).remove();
                }
            }
            mc_table_content_se();
            mc_table_ligature();
            // $("#mc_table_content").getNiceScroll().resize();
            return true;
        }
        var add_column_cnt = ui_column - ui_td_cnt;
        var content_add_p = mc_table_get_p_text();
        var str_add_html = "";
        var str_add_html_column = "";

        for (idx_num = 0; idx_num < add_column_cnt; idx_num++) {
            str_add_html_column += "<div class='mc_table_first_line'>" + ($("#mc_table_first_line").children().length + idx_num + 1) + "</div>";
            for (var idx_tr = 0; idx_tr < $(".mc_table_y").length; idx_tr++) {
                str_add_html = "<div class='mc_table_content' id='mc_table_content_" + ($("#mc_table_first_line").children().length + idx_num + 1) + "_" + (idx_tr + 1) + "' onclick=' mc_table_content_click(this);'>" + content_add_p + "</div>";

                $(".mc_table_y").eq(idx_tr).append(str_add_html);
            }
        }
        $("#mc_table_first_line").append(str_add_html_column);
        // $("#mc_table_content").getNiceScroll().resize();
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    删除对应元素数据
     * 参数:
     *    @param {string} $this 需要删除的jq元素
     * 返回：
     *    @return { Promise<String> }
     *     表格标签
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_table_remove_child($this) {
        if (0 >= ary_table_current_data_all.length) {
            return false;
        }
        var ui_networlk = $this.children("#mc_table_network").text();

        if (0 >= $this.children().length || !ui_networlk) {
            return false;
        }

        ui_networlk = ui_networlk.split(":")[1];
        ui_networlk = Number(ui_networlk);
        var ui_data_idx = mc_table_circulation_ary_get_idx(ui_networlk);

        if (ui_data_idx) {
            ui_data_idx = Number(ui_data_idx);
            var ary_this = ary_table_current_data_all[ui_data_idx].data;
            var ui_data_ary_idx = mc_table_find_elem_idx(ary_this, $this);

            ary_table_current_data_all[ui_data_idx].data.splice(ui_data_ary_idx, 1);
            ary_table_current_data = [];
            return true;
        }

        return false;
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    创建表格标签
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     表格标签
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_html_txt = function () {
        str_table_id = "mc_table" + mc_get_id();
        var str_table_style = "";
        var str_val_chg_callback_attr = "";
        var str_line = "<div id='mc_table_first_line'>";
        var str_column = "<div id='mc_table_first_column'>";
        var str_front = "<div id='mc_table_front' class='mc_table_front'></div>";
        var str_table_body_con = "";


        if (0 !== arr_style.length) {
            for (var idx_body_style = 0; idx_body_style < arr_style.length; idx_body_style++) {
                str_table_style += arr_style[idx_body_style][0] + ":" + arr_style[idx_body_style][1] + ";";
            }
            str_table_style = str_table_style.trim();
        }

        str_table_body_con += "<div id='mc_table_content'><div id='mc_table_content_body'>";
        var content_add_p = mc_table_get_p_text();

        for (var idx_y = 0; idx_y < table_line; idx_y++) {
            str_table_body_con += "<div class='mc_table_y'>";
            str_column += "<div class='mc_table_first_column'>" + (idx_y + 1) + "</div>";
            for (var idx_x = 0; idx_x < table_column; idx_x++) {
                if (0 === idx_y) {
                    str_line += "<div class='mc_table_first_line'>" + (idx_x + 1) + "</div>";
                }
                str_table_body_con += "<div class='mc_table_content'id='mc_table_content_" + (idx_x + 1) + "_" + (idx_y + 1) + "' onclick='mc_table_content_click(this);' >" + content_add_p + "</div>";
            }
            str_table_body_con += "</div>";
        }
        str_line += "</div>";
        str_column += "</div>";
        str_table_body_con += "</div></div>";
        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        return (
            "<div id='" + str_table_id + "' class='mc_table' style='" + str_table_style + "' " + str_val_chg_callback_attr + ">" + str_line + str_column + str_front + str_table_body_con + "</div>"
        );
    };
    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    取出函数名
     * 参数:
     *    @param {Function} func 函数
     * 返回：
     *    @return { Promise<String> }
     *     函数名称
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.2.17
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_get_func_key(func) {
        if ("function" !== typeof func) {
            return "";
        }

        /* 如果有必要，考虑使用 MDK 算func的哈希作为key */
        var func_name = func
            .toString()
            .split("(")[0]
            .split(" ")[1];

        func_name = func_name.trim();
        func_name = func_name.toLowerCase();

        if (
            "string" === typeof func_name &&
            0 < func_name.length &&
            "function" !== typeof g_obj_func_name_map[func_name]
        ) {
            g_obj_func_name_map[func_name] = func;
        }

        return func_name;
    }
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取p标签内容
 * 参数:
 *    无
 * 返回：
 *    @returns {Promise{String}} 基本p标签字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_table_get_p_text() {
    var content_add_p = "";

    for (var idx_add_p = 0; 4 > idx_add_p; idx_add_p++) {
        content_add_p += "<p ";
        switch (idx_add_p) {
        case 0:
            content_add_p += "id='mc_table_network' class='mc_table_network mc_table_content_p'>" + obj_lang_screen.MC_LANG_BTN_SCREEN_NETPORT + "<span id='network_num' class='network_num'>";
            break;
        case 1:
            content_add_p += "id='mc_table_receiving_card' class='mc_table_receiving_card mc_table_content_p' >" + obj_lang_screen.MC_LANG_BTN_SCREEN_RECEIVER + "<span id='receiver_num' class='receiver_num'>";
            break;
        case 2:
            content_add_p += "id='mc_table_width' class='mc_table_width mc_table_content_p'>" + obj_lang_screen.MC_LANG_BTN_SCREEN_WIDTH + "<span id='width_num' class='width_num'>";
            break;
        case 3:
            content_add_p += "id='mc_table_height' class='mc_table_height mc_table_content_p'>" + obj_lang_screen.MC_LANG_BTN_SCREEN_HEIGHT + "<span id='height_num' class='height_num'>";
            break;
        default:
            break;
        }
        content_add_p += "</span></p>";
    }
    content_add_p += "<i id='mc_table_se' class='mc_table_se'></i>";
    return content_add_p;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    给dom元素加事件
 * 参数:
 *    无
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_js_fun() {
    //提前将内容的left和top值存入
    (function mc_table_content_set_top_left() {
        for (var idx_column = 0; idx_column < $(".mc_table_y").length; idx_column++) {
            var top_num = idx_column * 99;

            $(".mc_table_y").eq(idx_column).children().attr("content_top", top_num);
            for (var idx_line = 0; idx_line < $(".mc_table_y").eq(idx_column).children().length; idx_line++) {
                var left_num = idx_line * 95;

                $(".mc_table_y").eq(idx_column).children().eq(idx_line).attr("content_left", left_num);
            }
        }
    })();
    // 滚轮事件
    $("#mc_table_content").off("scroll");
    $("#mc_table_content").on("scroll", function () {
        var ui_scroll_top = $("#mc_table_content_body").position().top + 30;
        var ui_scroll_left = $("#mc_table_content_body").position().left + 30;

        $("#mc_table_first_line").css("left", ui_scroll_left);
        $("#mc_table_first_column").css("top", ui_scroll_top);
    });
    //全选格单击事件
    $(".mc_table_front").off("click");
    $(".mc_table_front").on("click", function () {
        var obj_content = mc_content_click(true);
        var idx_quickly = obj_content.quick_line;

        idx_quickly = Number(idx_quickly);
        mc_table_fast_connections(idx_quickly, obj_content);
        $(".mc_table_content").addClass("mc_table_content_click_font");
        $(".mc_table_content").removeClass("mc_table_content_click_content");
    });
    //行格单击事件
    $(".mc_table_first_line").off("click");
    $(".mc_table_first_line").on("click", function (e) {
        $(".mc_table_content_click_font").removeClass("mc_table_content_click_font");
        $(".mc_table_content_click_content").removeClass("mc_table_content_click_content");
        var ul_idx = e.currentTarget.textContent;

        ul_idx = Number(ul_idx);
        var table_tr = $("#mc_table_content_body").children(".mc_table_y");

        for (var idx_y = 0; idx_y < table_tr.length; idx_y++) {
            var table_td = table_tr.eq(idx_y).children();

            table_td.eq(ul_idx - 1).addClass("mc_table_content_click_font");
        }
    });
    //列格单击事件
    $(".mc_table_first_column").off("click");
    $(".mc_table_first_column").on("click", function (e) {
        $(".mc_table_content_click_font").removeClass("mc_table_content_click_font");
        $(".mc_table_content_click_content").removeClass("mc_table_content_click_content");
        var ul_idx = e.currentTarget.textContent;
        var table_tr = $("#mc_table_content_body").children(".mc_table_y");

        ul_idx = Number(ul_idx);
        table_tr.eq(ul_idx - 1).children().addClass("mc_table_content_click_font");
    });
    //键盘事件
    $("#mc_table_content").off("keydown");
    $("#mc_table_content").on("keydown", function (event) {
        var $pith_content = $(".mc_table_content_click_content");

        if (37 !== event.keyCode && 38 !== event.keyCode && 39 !== event.keyCode && 40 !== event.keyCode) {
            return false;
        }
        if (0 >= $pith_content.length) {
            return false;
        }
        var $next_content = {};
        var ui_this_idx = $pith_content.index();

        switch (event.keyCode) {
        //左
        case 37:
            $next_content = $pith_content.prev();
            break;
            //上
        case 38:
            $next_content = $pith_content.parent().prev().children().eq(ui_this_idx);
            break;
            //右
        case 39:
            $next_content = $pith_content.next();

            break;
            // 下
        case 40:
            $next_content = $pith_content.parent().next().children().eq(ui_this_idx);
            break;
        default:
            break;
        }
        var str_class_name = $next_content.attr("class");

        if ("string" !== typeof str_class_name || -1 === str_class_name.indexOf("mc_table_content")) {
            return false;
        }
        mc_table_content_click($next_content[0]);
        mc_table_scroll_bar(event.keyCode, $next_content);
        return false;
    });
    //边界检测_滚动滚动条
    function mc_table_scroll_bar(ui_direction, $next_content) {
        var ui_scroll_length = 0;

        switch (ui_direction) {
        case 37:
            //左
            var ui_table_left = $("#mc_table_content").offset().left;
            var ui_content_left = $next_content.offset().left - 28;

            if (ui_table_left > ui_content_left) {
                ui_scroll_length = ui_content_left - ui_table_left;
                ui_scroll_length = $("#mc_table_content").scrollLeft() + ui_scroll_length;
                $("#mc_table_content").scrollLeft(ui_scroll_length);
            }
            break;
        case 38:
            //上
            var ui_table_top = $("#mc_table_content").offset().top;
            var ui_content_top = $next_content.offset().top - 28;

            if (ui_table_top > ui_content_top) {
                ui_scroll_length = ui_table_top - ui_content_top;
                ui_scroll_length = $("#mc_table_content").scrollTop() - ui_scroll_length;
                $("#mc_table_content").scrollTop(ui_scroll_length);
            }
            break;
        case 39:
            //右
            var ui_table_ringt_end = $("#mc_table_content").offset().left + $("#mc_table_content").width();
            var ui_content_right_end = $next_content.offset().left + $next_content.width();

            if (ui_table_ringt_end < ui_content_right_end) {
                ui_scroll_length = ui_content_right_end - ui_table_ringt_end;
                ui_scroll_length += $("#mc_table_content").scrollLeft();
                $("#mc_table_content").scrollLeft(ui_scroll_length);
            }
            break;
        case 40:
            // 下
            var ui_table_bottom_end = $("#mc_table_content").offset().top + $("#mc_table_content").height();
            var ui_content_bottom_end = $next_content.offset().top + $next_content.height();

            if (ui_content_bottom_end > ui_table_bottom_end) {
                ui_scroll_length = ui_content_bottom_end - ui_table_bottom_end;
                ui_scroll_length = $("#mc_table_content").scrollTop() + ui_scroll_length;
                $("#mc_table_content").scrollTop(ui_scroll_length);
            }
            break;
        default:
            break;
        }
    }
    //鼠标右键
    $(".mc_table").off("contextmenu");
    $(".mc_table").on("contextmenu", function (e) {
        e.preventDefault();
    });
    $(".mc_table").off("mouseup");
    $(".mc_table").on("mouseup", function (e) {
        e.preventDefault();
        if (3 === e.which) {
            mc_table_data_retracement();
        }
    });
    // $("#mc_table_content").getNiceScroll().resize();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    内容元素单机事件
 * 参数:
 *    @param {object} $this 需要操作的jq对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_content_click($this) {
    $this = $($this);
    //删除其他选中效果
    $(".mc_table_content_click_font").removeClass("mc_table_content_click_font");
    $(".mc_table_content_click_content").removeClass("mc_table_content_click_content");
    var ui_network = "";
    var ui_network_old = "";
    var obj_content = mc_content_click(false);
    var str_bgc_class = "";

    ui_network = Number(obj_content.network);
    //添加内容点击选中效果
    $this.addClass("mc_table_content_click_content");
    //获取当前网口在数据中的下标
    var ui_data_idx = mc_table_circulation_ary_get_idx(ui_network);

    //判断点击格子是否存在内容
    var str_this_display = $this.children("#mc_table_width").css("display");

    screen_Y_coordinate.set_dom_val((Number($this.parent().index()) + 1 + ""));
    screen_X_coordinate.set_dom_val((Number($this.index() + 1)) + "");

    if ("none" !== str_this_display) {
        ui_network_old = $this.children("#mc_table_network").text();
        ui_network_old = ui_network_old.split(":")[1];
        ui_network_old = Number(ui_network_old);
        //判断当前是否为留空
        if (0 !== ui_network && 0 !== ui_network_old) {
            var ui_data_idx_old = mc_table_circulation_ary_get_idx(ui_network_old);

            ui_data_idx_old = Number(ui_data_idx_old);
            screen_network_num.set_dom_val(ui_network_old.toString());

            var str_width_val = $(".mc_table_content_click_content").children("#mc_table_width").text().split(":")[1];
            var str_height_val = $(".mc_table_content_click_content").children("#mc_table_height").text().split(":")[1];

            screen_width.set_dom_val(str_width_val);
            screen_height.set_dom_val(str_height_val);

            mc_network_count(null, ui_network_old.toString());
            mc_screen_width(null, str_width_val);
            mc_screen_height(null, str_height_val);

            ary_table_current_data = ary_table_current_data_all[ui_data_idx_old].data;
            return;
        }
        //判断点击留空格子时有无勾选留空
        if (0 !== ui_network && 0 === ui_network_old) {
            return;
        }
        ui_data_idx = mc_table_circulation_ary_get_idx(ui_network_old);
        obj_content = mc_content_click(!ui_network_old);
        ui_network = Number(obj_content.network);
        ui_data_idx = Number(ui_data_idx);
        //删除当前表格背景
        str_bgc_class = "mc_table_internet_access_" + ui_network_old;
        $this.removeClass(str_bgc_class);
        //获取当前元素对应数组下标
        var ary_now_data = ary_table_current_data_all[ui_data_idx].data;
        var ui_this_idx = mc_table_find_elem_idx(ary_now_data, $this);

        //如果留空删除连线
        if (0 !== ui_network_old && 1 < ary_now_data.length) {
            var str_line_id = "";
            var ui_receiver = $this.children("#mc_table_receiving_card").text();

            ui_receiver = ui_receiver.split(":")[1];
            ui_receiver = Number(ui_receiver);
            if (0 === ui_this_idx) {
                ary_table_current_data_all[ui_data_idx].null_data.push(ui_receiver);
                //开头只删除往下的线
                str_line_id = ary_now_data[ui_this_idx].attr("id") + "_";
                str_line_id += ary_now_data[ui_this_idx + 1].attr("id");
                $("#" + str_line_id).remove();
            } else if (ui_this_idx !== ary_now_data.length - 1) {
                ary_table_current_data_all[ui_data_idx].null_data.push(ui_receiver);
                //中间删除传来和传出的两条线
                str_line_id = ary_now_data[ui_this_idx - 1].attr("id") + "_";
                str_line_id += ary_now_data[ui_this_idx].attr("id");
                $("#" + str_line_id).remove();
                str_line_id = ary_now_data[ui_this_idx].attr("id") + "_";
                str_line_id += ary_now_data[ui_this_idx + 1].attr("id");
                $("#" + str_line_id).remove();
                connect_line_mod(connect_line_html(ary_now_data[ui_this_idx - 1], ary_now_data[ui_this_idx + 1]));
            } else {
                //结尾只删除最后传出的一条线
                str_line_id = ary_now_data[ui_this_idx - 1].attr("id") + "_";
                str_line_id += ary_now_data[ui_this_idx].attr("id");
                $("#" + str_line_id).remove();
            }
        } else {
            ary_table_current_data_all[ui_data_idx].null_data = [];
        }
        //删除对应网口的元素
        ary_table_current_data_all[ui_data_idx].data.splice(ui_this_idx, 1);
        ui_data_idx = mc_table_circulation_ary_get_idx(ui_network);
    }
    //判断是否刷新数组及替换数组
    if (ui_data_idx) {
        ui_data_idx = Number(ui_data_idx);
        ary_table_current_data = ary_table_current_data_all[ui_data_idx].data;
    } else {
        ary_table_current_data = [];
    }
    mc_table_position_data(obj_content, $this, ui_network);
    //将数据数组添加入总数据数组中
    if (1 === ary_table_current_data.length) {
        ui_data_idx = mc_table_circulation_ary_get_idx(ui_network);
        if (ui_data_idx) {
            ui_data_idx = Number(ui_data_idx);
            ary_table_current_data_all[ui_data_idx].data = ary_table_current_data;
        } else {
            var obj_data = {
                network: ui_network,
                data: ary_table_current_data,
                null_data: []
            };

            ary_table_current_data_all.push(obj_data);
        }
    }
    mc_table_content_se();
}

function mc_table_position_data(obj_content, $this, ui_network) {
    //获取当前数据
    var str_li_bgc = "mc_table_internet_access_" + obj_content.network;
    var ui_data_idx = mc_table_circulation_ary_get_idx(ui_network);

    $this.addClass(str_li_bgc);
    //获取当前接收卡位置
    var ui_splitter = obj_lang_screen.MC_LANG_BTN_SCREEN_SET_NULL;

    if (0 !== ui_network) {
        //获取接收卡位置
        ui_splitter = 1;
        if (0 < ary_table_current_data.length) {
            ui_splitter = ary_table_current_data[ary_table_current_data.length - 1].children("#mc_table_receiving_card").text();
            ui_splitter = ui_splitter.split(":")[1];
            ui_splitter = Number(ui_splitter);
            ui_splitter++;
        }
        if (ui_data_idx) {
            ui_data_idx = Number(ui_data_idx);
            var ary_null = ary_table_current_data_all[ui_data_idx].null_data;

            if (0 < ary_null.length) {
                ui_splitter = 2501;
                var ui_null_idx = null;

                for (var idx_null = 0; idx_null < ary_null.length; idx_null++) {
                    if (ary_null[idx_null] > ui_splitter) {
                        continue;
                    }
                    ui_splitter = ary_null[idx_null];
                    ui_null_idx = idx_null;
                }
                ary_null.splice(ui_null_idx, 1);
                if (1 === ui_splitter) {
                    connect_line_mod(connect_line_html($this, ary_table_current_data[ui_splitter - 1]));
                } else {
                    connect_line_mod(connect_line_html(ary_table_current_data[ui_splitter - 2], $this));
                    connect_line_mod(connect_line_html($this, ary_table_current_data[ui_splitter - 1]));
                    var str_line_id = ary_table_current_data[ui_splitter - 2].attr("id") + "_";

                    str_line_id += ary_table_current_data[ui_splitter - 1].attr("id");
                    $("#" + str_line_id).remove();
                }
            } else {
                if (1 !== ui_splitter) {
                    connect_line_mod(connect_line_html(ary_table_current_data[ary_table_current_data.length - 1], $this));
                }
            }
        }
    }
    //显示p标签,修改标签内容
    $this.children("#mc_table_network").css({
        "display": "block",
        "opacity": "1"
    }).children("#network_num").text(ui_network);
    $this.children("#mc_table_receiving_card").css("display", "block").children("#receiver_num").text(ui_splitter);
    if ("number" !== typeof ui_splitter) {
        $this.children("#mc_table_receiving_card").css("display", "block").children("#receiver_num").html(ui_splitter);
        mc_lang_update_page(obj_lang_screen);
    }
    $this.children("#mc_table_width").css("display", "block").children("#width_num").text(obj_content.width);
    $this.children("#mc_table_height").css("display", "block").children("#height_num").text(obj_content.height);
    $this.children("#mc_table_se").css("display", "none");
    //如果是留空隐藏网口信息
    if (0 === ui_network) {
        $this.children("#mc_table_network").css("opacity", "0");
    }
    //将选中盒子添加入数据数组中
    ary_table_current_data.splice(ui_splitter - 1, 0, $this);
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    操作dom的数据回撤
 * 参数:
 *    无
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_retracement_network() {
    if (0 >= ary_table_current_data_all.length) {
        return;
    }
    var ui_network = "";
    var obj_content = mc_content_click(false);

    ui_network = Number(obj_content.network);
    if (0 > ui_network || 16 < ui_network) {
        return;
    }
    ary_table_current_data = [];
    var ui_data_idx = mc_table_circulation_ary_get_idx(ui_network);

    if (!ui_data_idx) {
        return;
    }
    ui_data_idx = Number(ui_data_idx);
    ary_table_current_data = ary_table_current_data_all[ui_data_idx].data;
    mc_table_data_retracement();
}

function mc_table_data_retracement() {
    if (0 >= ary_table_current_data.length) {
        return false;
    }
    //删除全选效果
    $(".mc_table_content_click_font").removeClass("mc_table_content_click_font");
    //获取数组最后一位下标
    var ui_end_id = ary_table_current_data.length - 1;
    var $obj_ary_end = ary_table_current_data[ui_end_id];

    //回退框选效果
    $(".mc_table_content_click_content").removeClass("mc_table_content_click_content");
    $obj_ary_end.addClass("mc_table_content_click_content");
    //查看当前网口
    var ui_internet_access = $obj_ary_end.children().eq(0).text();

    ui_internet_access = ui_internet_access.split(":")[1];
    ui_internet_access = Number(ui_internet_access);
    // 删除数组最后一个元素
    $obj_ary_end.children().css("display", "none");
    $obj_ary_end.removeClass("mc_table_internet_access_" + ui_internet_access);
    ary_table_current_data.pop();
    var ui_data_idx = mc_table_circulation_ary_get_idx(ui_internet_access);

    ui_data_idx = Number(ui_data_idx);
    ary_table_current_data_all[ui_data_idx].data = ary_table_current_data;
    mc_table_content_se();
    if (0 >= ary_table_current_data.length) {
        return true;
    }
    ui_end_id = ary_table_current_data.length - 1;
    $obj_ary_end = ary_table_current_data[ui_end_id];
    var str_line_id = $obj_ary_end.attr("id") + "_";

    str_line_id += $(".mc_table_content_click_content").attr("id");
    $("#" + str_line_id).remove();
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    快速连线
 * 参数:
 *    @param {number} idx 执行快速连线标识
 *    @param {string} obj_content 表格内容(可无)
 * 返回：
 *    @return { Promise<boolean> } 是否成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_fast_connections(idx, obj_content) {
    if ("number" !== typeof idx || 0 > idx) {
        return false;
    }
    var mc_table_fun_name = "mc_table_fast_connections_" + idx;

    for (var idx_css = 0; 16 > idx_css; idx_css++) {
        $(".mc_table_internet_access_" + idx_css).removeClass("mc_table_internet_access_" + idx_css);
    }
    window[mc_table_fun_name]();
    if (!window[mc_table_fun_name]()) {
        return false;
    }
    mc_table_fast_connections_content(obj_content);
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    快速连线方式
 * 参数:
 *    @param {string} table_id 当前表格id
 * 返回：
 *    @return { Promise<boolean> } 是否成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_fast_connections_0() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var b_is_direction = true;

    for (var idx_tr = 0; idx_tr < table_tr.length; idx_tr++) {
        var table_td = table_tr.eq(idx_tr).children();

        for (var idx_td = 0; idx_td < table_td.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_td.eq(idx_td));
                continue;
            }
            var ui_eq_idx = table_td.length - 1 - idx_td;

            ary_table_current_data.push(table_td.eq(ui_eq_idx));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}

function mc_table_fast_connections_1() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var b_is_direction = true;

    for (var idx_tr = table_tr.length - 1; 0 <= idx_tr; idx_tr--) {
        var table_td = table_tr.eq(idx_tr).children();

        for (var idx_td = 0; idx_td < table_td.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_td.eq(idx_td));
                continue;
            }
            var ui_eq_idx = table_td.length - 1 - idx_td;

            ary_table_current_data.push(table_td.eq(ui_eq_idx));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}

function mc_table_fast_connections_2() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var b_is_direction = false;

    for (var idx_tr = 0; idx_tr < table_tr.length; idx_tr++) {
        var table_td = table_tr.eq(idx_tr).children();

        for (var idx_td = 0; idx_td < table_td.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_td.eq(idx_td));
                continue;
            }
            var ui_eq_idx = table_td.length - 1 - idx_td;

            ary_table_current_data.push(table_td.eq(ui_eq_idx));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}

function mc_table_fast_connections_3() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var b_is_direction = false;

    for (var idx_tr = table_tr.length - 1; 0 <= idx_tr; idx_tr--) {
        var table_td = table_tr.eq(idx_tr).children();

        for (var idx_td = 0; idx_td < table_td.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_td.eq(idx_td));
                continue;
            }
            var ui_eq_idx = table_td.length - 1 - idx_td;

            ary_table_current_data.push(table_td.eq(ui_eq_idx));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}

function mc_table_fast_connections_4() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var table_td_cnt = table_tr.eq(0).children().length;
    var b_is_direction = true;

    for (var idx_tr = 0; idx_tr < table_td_cnt; idx_tr++) {
        for (var idx_td = 0; idx_td < table_tr.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_tr.eq(idx_td).children().eq(idx_tr));
                continue;
            }
            var ui_eq_idx = table_tr.length - 1 - idx_td;

            ary_table_current_data.push(table_tr.eq(ui_eq_idx).children().eq(idx_tr));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}

function mc_table_fast_connections_5() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var table_td_cnt = table_tr.eq(0).children().length;
    var b_is_direction = false;

    for (var idx_tr = 0; idx_tr < table_td_cnt; idx_tr++) {
        for (var idx_td = 0; idx_td < table_tr.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_tr.eq(idx_td).children().eq(idx_tr));
                continue;
            }
            var ui_eq_idx = table_tr.length - 1 - idx_td;

            ary_table_current_data.push(table_tr.eq(ui_eq_idx).children().eq(idx_tr));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}

function mc_table_fast_connections_6() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var table_td_cnt = table_tr.eq(0).children().length;
    var b_is_direction = true;

    for (var idx_tr = table_td_cnt - 1; 0 <= idx_tr; idx_tr--) {
        for (var idx_td = 0; idx_td < table_tr.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_tr.eq(idx_td).children().eq(idx_tr));
                continue;
            }
            var ui_eq_idx = table_tr.length - 1 - idx_td;

            ary_table_current_data.push(table_tr.eq(ui_eq_idx).children().eq(idx_tr));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}

function mc_table_fast_connections_7() {
    ary_table_current_data = [];
    var table_tr = $(".mc_table_y");
    var table_td_cnt = table_tr.eq(0).children().length;
    var b_is_direction = false;

    for (var idx_tr = table_td_cnt - 1; 0 <= idx_tr; idx_tr--) {
        for (var idx_td = 0; idx_td < table_tr.length; idx_td++) {
            if (b_is_direction) {
                ary_table_current_data.push(table_tr.eq(idx_td).children().eq(idx_tr));
                continue;
            }
            var ui_eq_idx = table_tr.length - 1 - idx_td;

            ary_table_current_data.push(table_tr.eq(ui_eq_idx).children().eq(idx_tr));
        }
        b_is_direction = !b_is_direction;
    }
    return true;
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    让所有表格为选中样式
 * 参数:
 *    @param {object} obj_content 当前页面数据
 * 返回：
 *    @return { Promise<boolean> } 是否成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_table_fast_connections_content(obj_content) {
    var obj_data = {
        network: obj_content.network,
        data: [],
        null_data: []
    };
    var ui_network = Number(obj_content.network);

    ary_table_current_data_all = [];
    obj_data.data = ary_table_current_data;
    ary_table_current_data_all.push(obj_data);
    var li_bgc = "mc_table_internet_access_" + obj_content.network;

    $(".mc_table_content").addClass(li_bgc).children().css("display", "block");
    $(".network_num").text(ui_network);
    $(".width_num").text(obj_content.width);
    $(".height_num").text(obj_content.height);
    for (var idx_content = 0; idx_content < ary_table_current_data.length; idx_content++) {
        ary_table_current_data[idx_content].children("#mc_table_receiving_card").children("#receiver_num").text((idx_content + 1));
    }
    mc_table_content_se();
    mc_table_ligature(obj_content);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    修改当前表格内容
 * 参数:
 *    无
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_content_updata() {
    var obj_content = mc_content_click();
    var $this = $(".mc_table_content_click_content");

    $this.children("#mc_table_width").children("#width_num").text(obj_content.width);
    $this.children("#mc_table_height").children("#height_num").text(obj_content.height);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    修改当前网口所有表格内容
 * 参数:
 *    无
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_table_content_updata_network() {
    var obj_content = mc_content_click(false);
    var ui_network = obj_content.network;

    ui_network = Number(ui_network);
    var ui_data_idx = mc_table_circulation_ary_get_idx(ui_network);

    if (ui_data_idx) {
        ui_data_idx = Number(ui_data_idx);
        for (var idx_cil = 0; idx_cil < ary_table_current_data_all[ui_data_idx].data.length; idx_cil++) {
            var $obj_network_children = ary_table_current_data_all[ui_data_idx].data[idx_cil];

            $obj_network_children.children("#mc_table_width").children("#width_num").text(obj_content.width);
            $obj_network_children.children("#mc_table_height").children("#height_num").text(obj_content.height);
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    查找数组中对应jq元素下标
 * 参数:
 *    @param {object} ary_data 查询数组
 *    @param {object} find_data 查询jq元素
 * 返回：
 *    @return { Promise<number> } 当前元素在数组中的下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_table_find_elem_idx(ary_data, find_data) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    for (var idx = 0; idx < ary_data.length; idx++) {
        if (ary_data[idx].is(find_data)) {
            return idx;
        }
    }
    return false;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    使所有数据开头结尾都有se样式
 * 参数:
 *    @param {object} ary_data 查询数组
 *    @param {object} find_data 查询元素
 * 返回：
 *    @return { Promise<number> } 当前元素在数组中的下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_table_content_se() {
    if (!Array.isArray(ary_table_current_data_all) || 0 >= ary_table_current_data_all.length) {
        return;
    }
    $(".mc_table_se").css({
        "display": "none",
        "background-color": "rgba(0,0,0,0)"
    });
    for (var idx_all = 0; idx_all < ary_table_current_data_all.length; idx_all++) {
        var ui_network = ary_table_current_data_all[idx_all].network;

        ui_network = Number(ui_network);
        if (0 === ui_network) {
            continue;
        }
        var ary_data = ary_table_current_data_all[idx_all].data;

        if (0 === ary_data.length) {
            continue;
        }
        if (1 === ary_data.length) {
            ary_data[0].children("#mc_table_se").text("S").css({
                "color": "#fc0dfa",
                "display": "block"
            });
        } else {
            ary_data[0].children("#mc_table_se").text("S").css({
                "display": "block",
                "background-color": "#affd0c",
                "color": "#fc0dfa",
                "z-index": "777"
            });
            ary_data[ary_data.length - 1].children("#mc_table_se").text("E").css({
                "display": "block",
                "background-color": "#fc0dfa",
                "z-index": "777",
                "color": "#b1d69e"
            });
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    重置网口
 * 参数:
 *    @param {number} ui_networlk 重置网口序号
 * 返回：
 *    @return { Promise<boolean> } 成功与否
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_tabel_reset_network(ui_networlk) {
    if (0 > ary_table_current_data_all.length) {
        return false;
    }
    ui_networlk = Number(ui_networlk);
    var ui_data_idx = mc_table_circulation_ary_get_idx(ui_networlk);

    if (!ui_data_idx) {
        return false;
    }
    ui_data_idx = Number(ui_data_idx);
    $(".mc_table_content_click_font").removeClass("mc_table_content_click_font");
    $(".mc_table_content_click_content").removeClass("mc_table_content_click_content");
    var li_bgc = "mc_table_internet_access_" + ui_networlk;

    $("." + li_bgc).removeClass(li_bgc);
    ary_table_current_data = ary_table_current_data_all[ui_data_idx].data;
    for (var idx_content = 0; idx_content < ary_table_current_data.length; idx_content++) {
        ary_table_current_data[idx_content].children().css("display", "none");
    }
    ary_table_current_data = [];
    ary_table_current_data_all.splice(ui_data_idx, 1);
    if (0 === ary_table_current_data_all.length) {
        $(".mod_hub_Line").remove();
    } else {
        mc_table_ligature();
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    刷新队列,两两连线
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<boolean> } 成功与否
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_table_ligature(obj_content) {
    if (0 > ary_table_current_data_all.length) {
        return false;
    }
    if (obj_content && obj_content.isLine) {
        return false;
    }
    $(".mod_hub_Line").remove();
    for (var idx_net = 0; idx_net < ary_table_current_data_all.length; idx_net++) {
        var ui_all_network = ary_table_current_data_all[idx_net].network;
        var ary_all_data = ary_table_current_data_all[idx_net].data;

        ui_all_network = Number(ui_all_network);
        if (0 === ui_all_network) {
            continue;
        }
        if (2 > ary_all_data.length) {
            continue;
        }
        var str_add_html = "";
        var idx_ligature = 0;

        for (idx_ligature = 0; idx_ligature < ary_all_data.length - 1; idx_ligature++) {
            var obj_line_data = connect_line_html(ary_all_data[idx_ligature], ary_all_data[idx_ligature + 1], ui_all_network);

            str_add_html += obj_line_data;
        }
        $("#mc_table_content_body").append(str_add_html);
    }
    return true;
}

function mc_tabale_get_line_clr(ui_network) {
    switch (ui_network) {
    case 1:
        return "#177cb0";
    case 2:
        return "#0001fe";
    case 3:
        return "#00ffff";
    case 4:
        return "#006f6c";
    case 5:
        return "#6f7000";
    case 6:
        return "#037200";
    case 7:
        return "#0dff00";
    case 8:
        return "#fefe09";
    case 9:
        return "#ff9000";
    case 10:
        return "#fe0100";
    case 11:
        return "#6c0201";
    case 12:
        return "#fd01ff";
    case 13:
        return "#6c016e";
    case 14:
        return "#636363";
    case 15:
        return "#6d6d6d";
    case 16:
        return "#010101";
    default:
        return false;
    }
}

function connect_line_html($this, $this_1, network) {
    var ui_left = 0;
    var ui_top = 0;

    ui_left = $this[0].getAttribute("content_left");
    ui_left = Number(ui_left);
    ui_left += 95 / 2;
    ui_top = $this[0].getAttribute("content_top");
    ui_top = Number(ui_top);
    ui_top += 99 / 2;
    var obj_start = {
        id: $this.attr("id"),
        left: ui_left,
        top: ui_top
    };

    ui_left = $this_1[0].getAttribute("content_left");
    ui_left = Number(ui_left);
    ui_left += 95 / 2;
    ui_top = $this_1[0].getAttribute("content_top");
    ui_top = Number(ui_top);
    ui_top += 99 / 2;
    var obj_end = {
        id: $this_1.attr("id"),
        left: ui_left,
        top: ui_top
    };
    var strat_div = obj_start;
    var end_div = obj_end;

    // 求线条长度绝对值
    var line_width = Math.abs(strat_div.left - end_div.left);
    var line_height = Math.abs(strat_div.top - end_div.top);

    // 矩形对角线长度
    var line_width_diagonal = Math.sqrt(Math.pow(line_width, 2) + Math.pow(line_height, 2));
    // 旋转角度值
    var angle_val = 0;

    if (obj_start.left === obj_end.left) {
        if (obj_start.top > obj_end.top) {
            angle_val = 270;
        } else {
            angle_val = 90;
        }
    } else if (obj_start.top === obj_end.top) {
        if (obj_start.left > obj_end.left) {
            angle_val = 180;
        } else {
            angle_val = 0;
        }
    } else {
        angle_val = Math.atan(line_height / line_width) / (Math.PI / 180).toFixed(5);
        // 判断开始块与结束块位置;设置角度
        if (parseInt(strat_div.left, 10) > parseInt(end_div.left, 10)) {
            angle_val = 180 - angle_val;
        }

        if (parseInt(strat_div.top, 10) > parseInt(end_div.top, 10)) {
            angle_val = -angle_val;
        }
    }

    var ui_network = 1;

    if ("undefined" !== typeof network) {
        ui_network = Number(network);
    } else {
        ui_network = $this.children("#mc_table_network").text();
        ui_network = ui_network.split(":")[1];
        ui_network = Number(ui_network);
        if (!ui_network) {
            ui_network = $this_1.children("#mc_table_network").text();
            ui_network = ui_network.split(":")[1];
            ui_network = Number(ui_network);
        }
    }
    var str_line_clr = mc_tabale_get_line_clr(ui_network);
    var line_id = strat_div.id + "_" + end_div.id;
    var svg_html = construct_straight_line(line_width_diagonal, true, str_line_clr);
    var svg_html_2 = construct_straight_line(line_width_diagonal, false, str_line_clr);

    var arrow_size = 20;

    var str_style_top = strat_div.top - (arrow_size / 2);
    var transform_val = "rotate( " + angle_val.toFixed(5) + "deg)";

    var str_style = "position:absolute;pointer-events:none;top:" + str_style_top + "px;left:" + strat_div.left + "px;width:" + (line_width_diagonal + arrow_size) + "px;height:" + arrow_size + "px;transform-origin:left;transform:" + transform_val + ";";
    var div_html = "<div id=" + line_id + " class='mod_hub_Line' style='" + str_style + "'>" + svg_html + svg_html_2 + "</div>";

    return div_html;
}

function connect_line_mod(div_html) {
    var obj_content = mc_content_click(false);

    if (obj_content.isLine) {
        return;
    }
    // 在外层svg的dom之前添加线条
    $("#mc_table_content_body").append(div_html);
    // $(".mc_mod_box").append(div_html)
}

function construct_straight_line(line_len, b_ccc, str_line_clr) {
    var path_d = "M0,0 L0,6 L9,3 z";
    // 颜色
    var line_col = str_line_clr;
    var marker_col = str_line_clr;
    // 整个线条的整体高度
    var line_height = 10;
    // 箭头大小
    var arrow_width = 0;
    var arrow_height = 20;

    var x1 = 0;
    var y1 = line_height;
    var x2 = line_len - arrow_width;

    var str_position = "style='position: absolute;'";

    if (!b_ccc) {
        str_position = "";
        arrow_width = 15;
        x2 = (line_len / 2) - arrow_width;
    }
    var y2 = line_height;

    var svg_width = "100%";
    var svg_heignt = arrow_height;
    var str_marker_id = "arrow_" + mc_get_id();
    var str_marker =
        "<marker id='" + str_marker_id + "' markerUnits='strokeWidth' markerWidth='8' markerHeight='8' refX='0' refY='3' orient='auto'><path d='" +
        path_d + "' style='fill:" + marker_col +
        "' /></marker>";

    var str_svg = "<svg " + str_position + " width=" + svg_width + " height=" + svg_heignt +
        " version='1.1' xmlns='http://www.w3.org/2000/svg'><defs>" + str_marker + "</defs><line x1=" + x1 +
        " y1=" + y1 + " x2=" + x2 + " y2=" + y2 +
        " stroke=" + line_col + " stroke-width='1.5' ";

    if (!b_ccc) {
        str_svg += "marker-end='url(#" + str_marker_id + ")' /></svg>";
    } else {
        str_svg += "/></svg>";
    }
    return str_svg;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取当前页面数据
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<object> } 当前页面数据生成对象
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.2.17
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_table_get_data_all() {
    if (0 >= ary_table_current_data_all.length) {
        return false;
    }
    var obj_data_res = {
        table_line: 0,
        table_column: 0,
        data: []
    };

    obj_data_res.table_line = $("#mc_table_first_line").children().length;
    obj_data_res.table_column = $("#mc_table_first_column").children().length;
    for (var idx_all = 0; idx_all < ary_table_current_data_all.length; idx_all++) {
        var obj_network_data = {
            network: 0,
            network_data: [],
            null_data: []
        };

        obj_network_data.network = ary_table_current_data_all[idx_all].network;
        obj_network_data.null_data = ary_table_current_data_all[idx_all].null_data;
        var str_data = "";

        for (var idx_network_data = 0; idx_network_data < ary_table_current_data_all[idx_all].data.length; idx_network_data++) {
            var $this = ary_table_current_data_all[idx_all].data[idx_network_data];
            var $this_x = $this.index() + 1;
            var $this_y = $this.parent().index() + 1;
            var $this_receiver = $this.children("#mc_table_receiving_card").text().split(":")[1];
            var $this_width = $this.children("#mc_table_width").text().split(":")[1];
            var $this_height = $this.children("#mc_table_height").text().split(":")[1];

            str_data = $this_x + "," + $this_y + "," + $this_receiver + "," + $this_width + "," + $this_height;
            obj_network_data.network_data.push(str_data);
        }
        obj_data_res.data.push(obj_network_data);
    }
    return obj_data_res;
}
